//=============================================================================
// MenuChoice_GameType
//=============================================================================

class MenuChoice_mutators extends MenuUIChoiceEnum
	config;

var MenuScreenHostGame hostparent;
var globalconfig int NumGameTypes; // Number of mutators
var globalconfig String     gameTypes[24]; //Class names for mutators
var localized String     gameNames[24]; //Human readable mutator names.

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	PopulateGameTypes();

	Super.InitWindow();

   SetInitialGameType();

   SetActionButtonWidth(179);
}

// ----------------------------------------------------------------------
// PopulateGameTypes()
// ----------------------------------------------------------------------

function PopulateGameTypes()
{
	local int typeIndex;

   for (typeIndex = 0; typeIndex < NumGameTypes; typeIndex++)
   {
      enumText[typeIndex]=gameNames[typeIndex];
   }
}

// ----------------------------------------------------------------------
// SetInitialGameType()
// ----------------------------------------------------------------------

function SetInitialGameType()
{
   local string TypeString;
   local int typeIndex;

   TypeString = player.ConsoleCommand("get" @ configsetting);

   for (typeIndex = 0; typeIndex < NumGameTypes; typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
   player.ConsoleCommand("set" @ configsetting @ GetModuleName(currentValue));
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
   local string TypeString;
   local int typeIndex;

   TypeString = player.ConsoleCommand("get" @ configsetting);

   for (typeIndex = 0; typeIndex < NumGameTypes; typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
   player.ConsoleCommand("set " $ configSetting $ " " $ GetModuleName(defaultValue));
   LoadSetting();
}

// ----------------------------------------------------------------------
// GetModuleName()
// For command line parsing
// ----------------------------------------------------------------------

function string GetModuleName(int GameIndex)
{
   return (gameTypes[GameIndex]);
}

// ----------------------------------------------------------------------
// SetValue()
// ----------------------------------------------------------------------

function SetValue(int newValue)
{
   local Class<Mutator> TypeClass;
   local Mutator CurrentType;
      
   Super.SetValue(newValue);
   
   if (GameTypes[NewValue] != "")    
   {
	   TypeClass = class<Mutator>( Player.DynamicLoadObject( GetModuleName(newValue), class'Class' ) );
      if (TypeClass != None)      
         CurrentType = Player.Spawn(TypeClass);
      
      if (CurrentType != None)
          CurrentType.Destroy();
   }
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     NumGameTypes=24
     gameTypes(0)="DeusEx.HejhujkaMutator"
     gameTypes(1)="DeusEx.GEPArena"
     gameTypes(2)="DeusEx.BioArena"
     gameTypes(3)="DeusEx.AssaultShotgunArena"
     gameTypes(4)="DeusEx.ProdArena"
     gameTypes(5)="DeusEx.InstaGib"
     gameTypes(6)="DeusEx.LowGravityArena"
     gameTypes(7)="DeusEx.DartArena"
     gameTypes(8)="DeusEx.SniperArena"
     gameTypes(9)="DeusEx.PlasmaArena"
     gameTypes(10)="DeusEx.AssaultArena"
     gameTypes(11)="DeusEx.NapalmArena"
     gameTypes(12)="DeusEx.PistolArena"
     gameNames(0)="No mutators"
     gameNames(1)="GEP Gun Arena"
     gameNames(2)="BioPistol Arena"
     gameNames(3)="Sabot Cannon Arena"
     gameNames(4)="Riot Prod Arena"
     gameNames(5)="InstaGib"
     gameNames(6)="Low Gravity"
     gameNames(7)="MiniCrossbow Arena"
     gameNames(8)="Sniper Arena"
     gameNames(9)="Plasma Arena"
     gameNames(10)="Assault Rifle Arena"
     gameNames(11)="Napalm Arena"
     gameNames(12)="Pistol Arena"
     defaultInfoWidth=243
     defaultInfoPosX=203
     HelpText="Choose mutator to play"
     actionText="Mutators"
     configSetting="MenuScreenHostGame Mutator"
}
